--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNatmosphere ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCfog
  local LOCspinStartValue
  local LOCundoState = on

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNsetupFogParams FUNfog =
  (
    DYNatmosphere.CBATMonOff.checked = isActive FUNfog
    DYNatmosphere.COATMcolor.color   = FUNfog.fog_color
    DYNatmosphere.SPATMnear.value    = FUNfog.near
    DYNatmosphere.SPATMfar.value     = FUNfog.far

    if FUNfog.fog_type == 1 then
    (
      DYNatmosphere.SPATMnear.enabled = false
      DYNatmosphere.SPATMfar.enabled = false
    )
    else
    (
      DYNatmosphere.SPATMnear.enabled = true
      DYNatmosphere.SPATMfar.enabled = true
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  checkbox    CBATMonoff    align:#left pos:[4,9]
  groupbox    GBATMgroup01  width:(DYNiniExplorerWidth - 21) height:56 pos:[4,31]
  colorpicker COATMcolor "" fieldwidth:(DYNiniExplorerWidth - 39) height:25 pos:[8,52]

  groupbox    GBATMgroup02  width:(DYNiniExplorerWidth - 21) height:70 pos:[4,93]
  spinner     SPATMnear     type:#float fieldwidth:60 range:[0,100,0]   scale:0.1 align:#left pos:[(DYNiniExplorerWidth - 96),113]
  spinner     SPATMfar      type:#float fieldwidth:60 range:[0,100,100] scale:0.1 align:#left pos:[(DYNiniExplorerWidth - 96),134]
  label       LBATMnear     width:95 align:#left pos:[13,116]
  label       LBATMfar      width:95 align:#left pos:[13,137]

  button      BUATMreset    width:(DYNiniExplorerWidth - 21) pos:[4,171]
  button      BUATMadvanced width:(DYNiniExplorerWidth - 21) pos:[4,196]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNatmosphere open do
  (
    DYNatmosphere.title = DYNuiRolloutNames[4]
    GBATMgroup01.text   = DYNuiResourcesGroups[4]
    GBATMgroup02.text   = DYNuiResourcesGroups[3]
    BUATMreset.text     = DYNuiResourcesButtons[13]
    BUATMadvanced.text  = DYNuiResourcesButtons[28]
    CBATMonOff.text     = DYNuiResourcesLabels[22]
    LBATMnear.text      = DYNuiResourcesLabels[23]
    LBATMfar.text       = DYNuiResourcesLabels[24]

    if numAtmospherics > 0 then
    (
      for i = 1 to numAtmospherics do
      (
        if (getAtmospheric i).name == DYNfogName then LOCfog = getAtmospheric i
      )
      if LOCfog == undefined then
      (
        LOCfog = fog()
        addAtmospheric LOCfog
        DYNFUNresetFogParams LOCfog
      )
    )
    else
    (
      LOCfog = fog()
      addAtmospheric LOCfog
      DYNFUNresetFogParams LOCfog
    )
    DYNFUNsetupFogParams LOCfog
    if (isActive LOCfog) == false then DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (DYNINIgreyedOutColor) else DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
  )

  on COATMcolor changed val do LOCfog.fog_color = val

  --- Spinner Near Fog Control
  on SPATMnear changed arg do (with undo label:DYNuiResourcesUndoLabels[1] LOCundoState LOCfog.near = arg)
  on SPATMnear buttonDown  do (LOCundoState = off; LOCspinStartValue = SPATMnear.value)
  on SPATMnear buttonUp    do
  (
    if LOCspinStartValue != SPATMnear.value then
    (
      with undo off LOCfog.near = LOCspinStartValue
      with undo label:DYNuiResourcesUndoLabels[1] on LOCfog.near = SPATMnear.value
    )
    LOCundoState = on
  )


  --- Spinner Far Fog Control
  on SPATMfar changed arg do (with undo label:DYNuiResourcesUndoLabels[1] LOCundoState LOCfog.far = arg)
  on SPATMfar buttonDown  do (LOCundoState = off; LOCspinStartValue = SPATMfar.value)
  on SPATMfar buttonUp    do
  (
    if LOCspinStartValue != SPATMfar.value then
    (
      with undo off LOCfog.far = LOCspinStartValue
      with undo label:DYNuiResourcesUndoLabels[1] on (LOCfog.far = SPATMfar.value)
    )
    LOCundoState = on
  )

  on CBATMonOff changed val do
  (
    setActive LOCfog val
    if (isActive LOCfog) == false then DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (DYNINIgreyedOutColor) else DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
  )

  on BUATMreset pressed do
  (
    DYNFUNresetFogParams LOCfog
    DYNFUNsetupFogParams LOCfog
  )

  on BUATMadvanced pressed do
  (
    editatmospheric LOCfog
  )
)
